package game;

import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;

public class HurtzoneSprite {
	
	
	private int xPos;
	private int yPos;
	
	private int minPos;
	private int maxPos;
	
	
	private boolean isVertical;
	
	private int duration;
	
	private int minimumWaitTime;
	
	private long lastFiring;
	
	private int fireChanceNumerator;
	private int fireChanceDenominator;
	
	private int warmupTime;
	private int damage;

	private double maxColor;
	private double minColor;
	
	public static final int WIDTH = 40;
	public static final int PIXELS_BETWEEN_LIGHTNING_POINTS = 25;
	
	private IntRect rect;
	
	private long currentTicksOfWarmupTime;
	private long currentTicksOfFiringTime;
	private long currentTicksOfWaitTime;
	
	private long desiredTotalTicksOfWarmupTime;
	private long desiredTotalTicksOfFiringTime;
	private long desiredTotalTicksOfWaitTime;
	
	public HurtzoneSprite(int theXPos, int theYPos, boolean shouldBeVertical, 
						  int theMinPos, int theMaxPos, int theDuration, int theMinimumWaitTime,
						  int theFireChanceNumerator, int theFireChanceDenominator, int theWarmupTime,
						  int theDamage, double theMaxColor, double theMinColor) {
		
		xPos = theXPos;
		yPos = theYPos;
		isVertical = shouldBeVertical;
		
		minPos = theMinPos;
		maxPos = theMaxPos;
		duration = theDuration;
		
		minimumWaitTime = theMinimumWaitTime;
		
		lastFiring = Long.MIN_VALUE;
		
		fireChanceNumerator = theFireChanceNumerator;
		fireChanceDenominator = theFireChanceDenominator;
		
		warmupTime = theWarmupTime;
		
		damage = theDamage;
		
		maxColor = theMaxColor;
		minColor = theMinColor;
		
		
		desiredTotalTicksOfFiringTime = (long) (duration * 1000000.0 / PonyPanel.TICK_LENGTH_NANO);
		desiredTotalTicksOfWarmupTime = (long) (warmupTime * 1000000.0 / PonyPanel.TICK_LENGTH_NANO);
		desiredTotalTicksOfWaitTime = (long) (minimumWaitTime * 1000000.0 / PonyPanel.TICK_LENGTH_NANO);
		
		currentTicksOfFiringTime = 0L;
		currentTicksOfWarmupTime = 0L;
		currentTicksOfWaitTime = 0L;
		
		if(isVertical) {
			rect = new IntRect(xPos - WIDTH/2, minPos, WIDTH, maxPos - minPos);
		} else {
			rect = new IntRect(minPos, yPos - WIDTH/2, maxPos - minPos, WIDTH);
		}
		
	}
	
	public void update() {
		
		
		if(isWarmingUp()) {
			currentTicksOfWarmupTime--;
			currentTicksOfFiringTime--;
			currentTicksOfWaitTime--;
		} else if(isFiring()) {
			currentTicksOfFiringTime--;
			currentTicksOfWaitTime--;
		} else if(isWaiting()) {
			currentTicksOfWaitTime--;
		} else {
			double rand = Math.random();
			
			rand *= fireChanceDenominator;
			
			
			
			if(rand < fireChanceNumerator) {
				currentTicksOfFiringTime = desiredTotalTicksOfFiringTime;
				currentTicksOfWaitTime = desiredTotalTicksOfWaitTime;
				currentTicksOfWarmupTime = desiredTotalTicksOfWarmupTime;
			}
		}
		
		
//		if(isFiring()) {
//			//do nothing; everything else pays attention & performs the "hurt" logic
//			
//		} else if(lastFiring + minimumWaitTime < System.currentTimeMillis()) {
//			
//			//decide if we start firing or not
//			
//			double rand = Math.random();
//			
//			rand *= fireChanceDenominator;
//			
//			
//			
//			if(rand < fireChanceNumerator) {
//				lastFiring = System.currentTimeMillis();
//			}
//			
//		}
 		
	}
	
	public boolean isFiring() {
//		if(duration <= 0 || (!isWarmingUp() && lastFiring + duration > System.currentTimeMillis())) {
//			return true;
//		} else {
//			return false;
//		}
		
		if(duration <= 0)
			return true;
		
		if(!isWarmingUp()) {
			if(currentTicksOfFiringTime > 0)
				return true;
		}
		
		return false;
		
	}
	
	public boolean isWarmingUp() {
//		if(duration > 0 && lastFiring + warmupTime > System.currentTimeMillis()) {
//			return true;
//		} else {
//			return false;
//		}
		
		return currentTicksOfWarmupTime > 0;
		
	}
	
	public boolean isWaiting() {
		if(!isWarmingUp() && !isFiring()) {
			return currentTicksOfWaitTime > 0;
		}
		
		return false;
	}
	
	
	public void draw(Graphics g, int cameraXPos, int cameraYPos) {
		drawInner(g, cameraXPos, cameraYPos);
		drawInner(g, cameraXPos, cameraYPos);
	}
	
	
	public void drawInner(Graphics g, int cameraXPos, int cameraYPos) {
		
		
		if(isWarmingUp()) {
			
			Color origColor = g.getColor();
			
			double rand = Math.random();
			
			rand *= (maxColor - minColor);
			rand += minColor;
			
			g.setColor(PlayingWithCosine.scalarToColor(rand));
			
			
			ArrayList<IntPoint> pointArray = new ArrayList<IntPoint>();
			
			int countOfPoints = (maxPos - minPos) / PIXELS_BETWEEN_LIGHTNING_POINTS;
			
			
			if(!isVertical) {
				
				
				
				int xDrawMin = minPos - cameraXPos + PonyPanel.PLAY_AREA_WIDTH / 2;
				int xDrawMax = maxPos - cameraXPos + PonyPanel.PLAY_AREA_WIDTH / 2;
				
				int yDrawBase = yPos - cameraYPos + PonyPanel.PANEL_HEIGHT / 2;
				
				
				for(int i = 0; i < countOfPoints; i++) {
					
					if(i == 0) {
						pointArray.add(new IntPoint(xDrawMin, yDrawBase));
					} else {
						pointArray.add(new IntPoint(xDrawMin + PIXELS_BETWEEN_LIGHTNING_POINTS * i + ((int) (Math.random() * WIDTH - WIDTH / 2)), yDrawBase + ((int) (Math.random() * WIDTH - WIDTH / 2))));
					}
					
				}
				
				pointArray.add(new IntPoint(xDrawMax, yDrawBase));
				
				
			} else {
				
				int yDrawMin = minPos - cameraYPos + PonyPanel.PANEL_HEIGHT / 2;
				int yDrawMax = maxPos - cameraYPos + PonyPanel.PANEL_HEIGHT / 2;
				
				int xDrawBase = xPos - cameraXPos  + PonyPanel.PLAY_AREA_WIDTH / 2;
				
				
				for(int i = 0; i < countOfPoints; i++) {
					
					if(i == 0) {
						pointArray.add(new IntPoint(xDrawBase, yDrawMin));
					} else {
						pointArray.add(new IntPoint(xDrawBase + ((int) (Math.random() * WIDTH - WIDTH / 2)), yDrawMin + PIXELS_BETWEEN_LIGHTNING_POINTS * i + ((int) (Math.random() * WIDTH - WIDTH / 2))));
					}
					
				}
				
				pointArray.add(new IntPoint(xDrawBase, yDrawMax));
				
			}
			
			
			for(int i = 0; i < pointArray.size(); i++) {
				
				g.drawLine(pointArray.get(i).x, pointArray.get(i).y - WIDTH / 8, pointArray.get(i).x, pointArray.get(i).y + WIDTH / 8);
				g.drawLine(pointArray.get(i).x + WIDTH / 8, pointArray.get(i).y, pointArray.get(i).x - WIDTH / 8, pointArray.get(i).y);
				
			}
			
			g.setColor(origColor);
			
			
		} else if(isFiring()) {
			
			
			Color origColor = g.getColor();
			
			double rand = Math.random();
			
			rand *= (maxColor - minColor);
			rand += minColor;
			
			g.setColor(PlayingWithCosine.scalarToColor(rand));
			
			
			ArrayList<IntPoint> pointArray = new ArrayList<IntPoint>();
			
			int countOfPoints = (maxPos - minPos) / PIXELS_BETWEEN_LIGHTNING_POINTS;
			
			
			if(!isVertical) {
				
				
				
				int xDrawMin = minPos - cameraXPos + PonyPanel.PLAY_AREA_WIDTH / 2;
				int xDrawMax = maxPos - cameraXPos + PonyPanel.PLAY_AREA_WIDTH / 2;
				
				int yDrawBase = yPos - cameraYPos + PonyPanel.PANEL_HEIGHT / 2;
				
				
				for(int i = 0; i < countOfPoints; i++) {
					
					if(i == 0) {
						pointArray.add(new IntPoint(xDrawMin, yDrawBase));
					} else {
						pointArray.add(new IntPoint(xDrawMin + PIXELS_BETWEEN_LIGHTNING_POINTS * i + ((int) (Math.random() * WIDTH - WIDTH / 2)), yDrawBase + ((int) (Math.random() * WIDTH - WIDTH / 2))));
					}
					
				}
				
				pointArray.add(new IntPoint(xDrawMax, yDrawBase));
				
				
			} else {
				
				int yDrawMin = minPos - cameraYPos + PonyPanel.PANEL_HEIGHT / 2;
				int yDrawMax = maxPos - cameraYPos + PonyPanel.PANEL_HEIGHT / 2;
				
				int xDrawBase = xPos - cameraXPos + PonyPanel.PLAY_AREA_WIDTH / 2;
				
				
				for(int i = 0; i < countOfPoints; i++) {
					
					if(i == 0) {
						pointArray.add(new IntPoint(xDrawBase, yDrawMin));
					} else {
						pointArray.add(new IntPoint(xDrawBase + ((int) (Math.random() * WIDTH - WIDTH / 2)), yDrawMin + PIXELS_BETWEEN_LIGHTNING_POINTS * i + ((int) (Math.random() * WIDTH - WIDTH / 2))));
					}
					
				}
				
				pointArray.add(new IntPoint(xDrawBase, yDrawMax));
				
			}
			
			
			for(int i = 0; i < pointArray.size()-1; i++) {
				
				g.drawLine(pointArray.get(i).x, pointArray.get(i).y, pointArray.get(i + 1).x, pointArray.get(i + 1).y);
				
			}
			
			g.setColor(origColor);
			
		}
		
		
	}
	
	
	
	public class IntPoint {
		public int x;
		public int y;
		
		public IntPoint(int theX, int theY) {
			x = theX;
			y = theY;
		}
	}
	
	public IntRect getRect() {
		return rect;
	}
	
	public int getDamage() {
		return damage;
	}
	
	
	public HurtzoneSprite(BufferedReader in) throws IOException {
		
		String inputter = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("/hurtzone") || inputter.contains("/room")) {
				break;
			} else if(inputter.contains("min:")) {
				minPos = Integer.parseInt(inputter.substring(4).trim());
			} else if(inputter.contains("max:")) {
				maxPos = Integer.parseInt(inputter.substring(4).trim());
			} else if(inputter.contains("x:")) {
//				System.err.println("inputter is: " + inputter + ", and inputter.substring(2).trim(): " + inputter.substring(2).trim());
				xPos = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("y:")) {
				yPos = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("horizontal")) {
				isVertical = false;
			} else if(inputter.contains("vertical")) {
				isVertical = true;
			} else if(inputter.contains("duration:")) {
				duration = Integer.parseInt(inputter.substring(9).trim());
			} else if(inputter.contains("minTimeBetween:")) {
				minimumWaitTime = Integer.parseInt(inputter.substring(15).trim());
			} else if(inputter.contains("chancePerTickNumerator:")) {
				fireChanceNumerator = Integer.parseInt(inputter.substring(23).trim());
			} else if(inputter.contains("chancePerTickDenominator:")) {
				fireChanceDenominator = Integer.parseInt(inputter.substring(25).trim());
			} else if(inputter.contains("warmupTime:")) {
				warmupTime = Integer.parseInt(inputter.substring(11).trim());
			} else if(inputter.contains("damage:")) {
				damage = Integer.parseInt(inputter.substring(7).trim());
			} else if(inputter.contains("minColor:")) {
				minColor = Double.parseDouble(inputter.substring(9).trim());
			} else if(inputter.contains("maxColor:")) {
				maxColor = Double.parseDouble(inputter.substring(9).trim());
			}
			
			
		}
		
		
		if(isVertical) {
			rect = new IntRect(xPos - WIDTH/2, minPos, WIDTH, maxPos - minPos);
		} else {
			rect = new IntRect(minPos, yPos - WIDTH/2, maxPos - minPos, WIDTH);
		}
		
		
		
		desiredTotalTicksOfFiringTime = (long) (duration * 1000000.0 / PonyPanel.TICK_LENGTH_NANO);
		desiredTotalTicksOfWarmupTime = (long) (warmupTime * 1000000.0 / PonyPanel.TICK_LENGTH_NANO);
		desiredTotalTicksOfWaitTime = (long) (minimumWaitTime * 1000000.0 / PonyPanel.TICK_LENGTH_NANO);
		
		currentTicksOfFiringTime = 0L;
		currentTicksOfWarmupTime = 0L;
		currentTicksOfWaitTime = 0L;
		
	}
	
}
